package com.burhanstore.neonbubblequest.Utils.adapter

import android.app.Activity
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.burhanstore.neonbubblequest.R
import com.burhanstore.neonbubblequest.Utils.AppString.formatDate
import com.burhanstore.neonbubblequest.Utils.model.RedeemsModel


class RedeemsAdapter(
    private val activity: Activity,
    private val trackList: List<RedeemsModel>,
    private val onItemClick: (RedeemsModel) -> Unit
) : RecyclerView.Adapter<RedeemsAdapter.TrackViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): TrackViewHolder {
        val view = LayoutInflater.from(activity).inflate(R.layout.redeem_hisitem, parent, false)
        return TrackViewHolder(view)
    }

    override fun onBindViewHolder(holder: TrackViewHolder, position: Int) {
        val item = trackList[position]

        // holder.title.text = item.py_title + " - " + item.py_amout + " " + item.py_currency
        holder.title.text = item.py_title


        Log.d(
            "RedeemsAdapter",
            "Binding item at position $position: created_at = ${item.created_at}"
        )
        val formattedDate = formatDate(item.created_at)
        holder.date.text = formattedDate
        holder.transaction_id.text = item.op1
        holder.app_amount.text = item.py_currency + item.py_amout



        if (item.status.equals("1")) {
            holder.Status.text = "Pending"
        } else if (item.status.equals("2")) {
            holder.Status.text = "Paid"
        } else {
            holder.Status.text = "Unknown"
        }


    }

    override fun getItemCount(): Int = trackList.size

    inner class TrackViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val title: TextView = itemView.findViewById(R.id.title)
        val date: TextView = itemView.findViewById(R.id.date)
        val transaction_id: TextView = itemView.findViewById(R.id.transaction_id)
        val Status: TextView = itemView.findViewById(R.id.Status)
        val app_amount: TextView = itemView.findViewById(R.id.app_amount)
    }
}